/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWActionType;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Vector;

public final class VWSimpleInstruction
extends VWInstructionDefinition
implements Serializable {
    private static final long serialVersionUID = 7473L;
    private String[] params = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-12-11 00:35:29 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/PUI_460_FP01_Int/1 $";
    }

    protected VWSimpleInstruction() throws VWException {
    }

    protected VWSimpleInstruction(VWCompoundStepDefinition aStep, int theInstructionId, int theInstructionType, String[] theParameters) throws VWException {
        super(aStep, theInstructionId, theInstructionType);
        if (theInstructionType == 29 || theInstructionType == 19) {
            throw new VWException("vw.api.VWSimpleInstructonBadActionType", "The instruction type {0} is not a valid instruction for a VWSimpleInstruction object", VWActionType.typeToString(theInstructionType));
        }
        this.setParams(theParameters);
    }

    public String[] getParams() {
        return this.params;
    }

    public void setParams(String[] theParams) throws VWException {
        int requiredParamCount = VWActionType.numberOfParameters(this.action);
        int newCount = theParams == null ? 0 : theParams.length;
        if (requiredParamCount != 999 && newCount != requiredParamCount && (this.action != 1 || newCount != 3)) {
            throw new VWException("vw.api.VWSimpleInstructionBadParamCount", "Length of the params array is {0}, expected length for action {1} should be {2}", String.valueOf(newCount), VWActionType.typeToString(this.action), String.valueOf(requiredParamCount));
        }
        this.params = theParams;
    }

    public void validate(VWSession theSession, Vector EDefVector, VWCompoundStepDefinition myStep) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext, myStep);
    }

    /*
     * Unable to fully structure code
     */
    protected void validate(VWValidationContext validationContext, VWCompoundStepDefinition myStep) throws VWException {
        paramCount = this.params == null ? 0 : this.params.length;
        switch (this.action) {
            case 8: 
            case 17: 
            case 24: 
            case 27: 
            case 28: 
            case 42: {
                if (paramCount == 0) break;
                theMessage = new VWString("vw.api.VWSimpleInstructionexpectedZeroParams", "expected 0 parameters, for action {0}, actual count is {1}.", VWActionType.typeToString(this.action), String.valueOf(paramCount));
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 16: {
                if (paramCount == 1) break;
                theMessage = new VWString("vw.api.VWSimpleInstructionexpectedOneParam", "expected 1 parameter for action {0}, actual count is {1}.", VWActionType.typeToString(this.action), String.valueOf(paramCount));
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
                break;
            }
            case 38: {
                if (paramCount == 2) break;
                theMessage = new VWString("vw.api.VWSimpleInstructionexpectedTwoParams", "expected 2 parameters for action {0}, actual count is {1}.", VWActionType.typeToString(this.action), String.valueOf(paramCount));
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
                break;
            }
            case 0: {
                if (paramCount == 0) {
                    theMessage = new VWString("vw.api.VWSimpleInstructionAssignmentInsHasNoParams", "Assignment instruction contains no assignments.");
                    theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                    break;
                }
                if (paramCount % 2 == 0) break;
                theMessage = new VWString("vw.api.VWSimpleInstructionExpectedEvenNumParams", "expected even number of parameters for action {0}, actual count is {1}.", VWActionType.typeToString(this.action), String.valueOf(paramCount));
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
                break;
            }
            case 1: {
                if (paramCount == 3 || paramCount == 4) break;
                theMessage = new VWString("vw.api.VWSimpleInstructionexpectedFourParams", "expected 3 or 4 parameters for action {0}, actual count is {1}.", VWActionType.typeToString(this.action), String.valueOf(paramCount));
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
                break;
            }
            case 23: 
            case 37: {
                if (paramCount >= 2) break;
                theMessage = new VWString("vw.api.VWSimpleInstructionexpectedAtLeastTwoParams", "expected 2 or more parameters for action {0}, actual count is {1}.", VWActionType.typeToString(this.action), String.valueOf(paramCount));
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new VWException("vw.api.VWInstructonDefinitionBadAction", "Validating simple instruction, found unexpected action type value: {0}", String.valueOf(this.action));
            }
        }
        for (i = 0; i < paramCount; ++i) {
            if (this.params[i] != null && this.params[i].compareTo("") != 0 || this.action == 1 && i == 3) continue;
            theMessage = new VWString("vw.api.VWSimpleInstructionNullParameter", "parameter {0} is null or empty, it must have a non-null/non-empty value.", String.valueOf(i));
            theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
            validationContext.addValidationError(theError);
        }
        myWflSignature = myStep.getMap().getWorkflow().getWorkflowSignature(validationContext);
        myBaseWflSignature = myStep.getMap().getWorkflow().getBaseWorkflowSignature(validationContext);
        switch (this.action) {
            case 5: {
                if (this.params == null || this.params[0] == null || VWMapDefinition.mapNameToId(this.params[0]) != 0) break;
                try {
                    myStep.getMap().getWorkflow().getMap(this.params[0]);
                }
                catch (Exception e) {
                    if (myBaseWflSignature != null && myBaseWflSignature.isInstructionSheetName(this.params[0])) break;
                    theMessage = new VWString("vw.api.VWSimpleInstructionMapNotFound", "The map being called, {0}, was not found in this workflow definition or the parent workflow defintion.", this.params[0]);
                    theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
                break;
            }
            case 7: {
                if (this.params == null || this.params[0] == null || this.params[0].length() == 0) break;
                compRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(this.params[0], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                if (theErrorStrings != null) {
                    errorCount = theErrorStrings.length;
                    for (i = 0; i < errorCount; ++i) {
                        theMessage = new VWString("vw.api.VWSimpleInstructionSyntaxErrorInDelayTime", "Syntax error in delay time expression : {0}", theErrorStrings[i]);
                        theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    }
                    break;
                }
                if (!compRes.getResultIsArray() && compRes.getResultType() == 16) break;
                theMessage = new VWString("vw.api.VWSimpleInstructionDelayNotTime", "Delay parameter must be a time expression, found a {0}{1}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() != false ? "[ ]" : ""));
                theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
                break;
            }
            case 14: {
                if (this.params == null || this.params[0] == null || this.params[0].length() == 0) break;
                compRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(this.params[0], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                if (theErrorStrings != null) {
                    errorCount = theErrorStrings.length;
                    for (i = 0; i < errorCount; ++i) {
                        theMessage = new VWString("vw.api.VWSimpleInstructionSyntaxErrorInRetryOption", "Syntax error in retry option of return instruction (boolean expression) : {0}", theErrorStrings[i]);
                        theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    }
                    break;
                }
                if (!compRes.getResultIsArray() && compRes.getResultType() == 4) break;
                theMessage = new VWString("vw.api.VWSimpleInstructionTimerRetryNotBoolean", "Retry option parameter must be a boolean expression, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() != false ? "[ ]" : ""));
                theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
                break;
            }
            case 9: 
            case 13: 
            case 16: {
                if (this.params == null || this.params[0] == null || this.params[0].length() == 0) break;
                compRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(this.params[0], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                if (theErrorStrings != null) {
                    errorCount = theErrorStrings.length;
                    for (i = 0; i < errorCount; ++i) {
                        theMessage = new VWString("vw.api.VWSimpleInstructionSyntaxErrorInTimerName", "Syntax error in timer name string expression : {0}", theErrorStrings[i]);
                        theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    }
                    break;
                }
                if (!compRes.getResultIsArray() && compRes.getResultType() == 2) break;
                theMessage = new VWString("vw.api.VWSimpleInstructionTimerNameNotStringA", "Timer name parameter must be a string expression, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() != false ? "[ ]" : ""));
                theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
                break;
            }
            case 1: {
                if (this.params != null && this.params[0] != null && this.params[0].length() != 0) {
                    compRes = new VWCompiledExpr();
                    theErrorStrings = VWExpr.compileVWExpr(this.params[0], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                    if (theErrorStrings != null) {
                        errorCount = theErrorStrings.length;
                        for (i = 0; i < errorCount; ++i) {
                            theMessage = new VWString("vw.api.VWSimpleInstructionSyntaxErrorInTimerName", "Syntax error in timer name string expression : {0}", theErrorStrings[i]);
                            theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError);
                        }
                    } else if (compRes.getResultIsArray() || compRes.getResultType() != 2) {
                        theMessage = new VWString("vw.api.VWSimpleInstructionTimerNameNotString", "Timer name parameter must be a string expression, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() != false ? "[ ]" : ""));
                        theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    }
                }
                if (this.params != null && this.params[1] != null && this.params[1].length() != 0) {
                    compRes = new VWCompiledExpr();
                    theErrorStrings = VWExpr.compileVWExpr(this.params[1], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                    if (theErrorStrings != null) {
                        errorCount = theErrorStrings.length;
                        for (i = 0; i < errorCount; ++i) {
                            theMessage = new VWString("vw.api.VWSimpleInstructionSyntaxErrorInExpirationTime", "Syntax error in expiration time expression : {0}", theErrorStrings[i]);
                            theError = new VWValidationError(7, 1, myStep.getName(), this.params[1], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError);
                        }
                    } else if (compRes.getResultIsArray() || compRes.getResultType() != 16) {
                        theMessage = new VWString("vw.api.VWSimpleInstructionExpirationTimeNotTime", "Expiration time expression parameter must be a time expression, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() != false ? "[ ]" : ""));
                        theError = new VWValidationError(7, 1, myStep.getName(), this.params[1], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    }
                }
                if (this.params == null || this.params[2] == null || VWMapDefinition.mapNameToId(this.params[2]) != 0) ** GOTO lbl161
                try {
                    myStep.getMap().getWorkflow().getMap(this.params[2]);
                }
                catch (Exception e) {
                    if (myBaseWflSignature != null && myBaseWflSignature.isInstructionSheetName(this.params[2])) ** GOTO lbl161
                    theMessage = new VWString("vw.api.VWSimpleInstructionTimerMapNotFound", "The map, {0}, to be called when the timer expires was not found in this or the parent workflow definition.", this.params[2]);
                    theError = new VWValidationError(7, 1, myStep.getName(), this.params[2], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
lbl161:
                // 4 sources

                if (this.params == null || this.params.length != 4 || this.params[3] == null || this.params[3].length() == 0) break;
                compRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(this.params[3], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                if (theErrorStrings != null) {
                    errorCount = theErrorStrings.length;
                    for (i = 0; i < errorCount; ++i) {
                        theMessage = new VWString("vw.api.VWSimpleInstructionSyntaxErrorInPreemptiveTime", "Syntax error in preemptive time expression : {0}", theErrorStrings[i]);
                        theError = new VWValidationError(7, 1, myStep.getName(), this.params[3], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    }
                    break;
                }
                if (!compRes.getResultIsArray() && compRes.getResultType() == 16) break;
                theMessage = new VWString("vw.api.VWSimpleInstructionDelayPreemptiveTimeNotTime", "Preemptive time parameter must be a time expression, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() != false ? "[ ]" : ""));
                theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
                break;
            }
            case 23: {
                theQueueDef = null;
                theOpDef = null;
                theParamDefs = null;
                defParamCount = 0;
                if (this.params != null && this.params[0] != null) {
                    try {
                        theQueueDef = validationContext.getQueueDefinition(this.params[0]);
                    }
                    catch (VWException e) {
                        theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], e.getMessage() + " (" + this.params[0] + ")", myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    }
                }
                if (this.params != null && this.params[1] != null && theQueueDef != null) {
                    try {
                        theOpDef = theQueueDef.getOperation(this.params[1]);
                        theParamDefs = theOpDef.getParameterDefinitions();
                        if (theParamDefs != null) {
                            defParamCount = theParamDefs.length;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (theOpDef == null) {
                    theMessage = new VWString("vw.api.VWSimpleInstructionInvalidOperationForQueue", "Execute instruction uses operation, {0}, which is not defined for queue {1}.", this.params[1], this.params[0]);
                    theError = new VWValidationError(7, 1, myStep.getName(), this.params[1], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                    break;
                }
                if (this.params.length - 2 != defParamCount) {
                    theMessage = new VWString("vw.api.VWSimpleInstructionExecuteWrongNumberOfParameters", "Execute instruction for operation, {0}, requires {1} parameters, found {2}.", this.params[0] + "." + this.params[1], String.valueOf(defParamCount), String.valueOf(this.params.length - 2));
                    theError = new VWValidationError(7, 1, myStep.getName(), null, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                    break;
                }
                if (defParamCount <= 0) break;
                for (i = 2; i < this.params.length; ++i) {
                    sParamName = theParamDefs[i - 2].getName();
                    if (sParamName == null) {
                        sParamName = "";
                    }
                    if (this.params[i] == null || this.params[i].compareTo("") == 0) {
                        theMessage = new VWString("vw.api.VWSimpleInstructionExecuteOpParamIsNull", "Execute instruction, operation parameter {0} is null or empty", String.valueOf(i) + " - (" + sParamName + ")");
                        theError = new VWValidationError(1, 1, myStep.getName(), sParamName, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                        continue;
                    }
                    compRes = null;
                    theErrorStrings = null;
                    if (theParamDefs[i - 2].getMode() == 3 || theParamDefs[i - 2].getMode() == 2) {
                        compRes = new VWCompiledRefExpr();
                        theErrorStrings = VWExpr.compileVWExpr(":=" + this.params[i], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                        if (theErrorStrings != null && VWExpr.compileVWExpr(this.params[i], myWflSignature, myBaseWflSignature, null, null, true, tmpRes = new VWCompiledExpr()) == null) {
                            theMessage = new VWString("vw.api.VWSimpleInstructionlValueRequired", "Execute instruction for operation, {0}, parameter[{1}], the parameter expression must be an LValue (suitable for the LHS of an assignment)", "\"" + this.params[0] + "." + this.params[1] + "\"", String.valueOf(i - 1) + " - (" + sParamName + ")");
                            theError = new VWValidationError(7, 1, myStep.getName(), sParamName, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError);
                        }
                    } else {
                        compRes = new VWCompiledExpr();
                        theErrorStrings = VWExpr.compileVWExpr(this.params[i], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                    }
                    if (theErrorStrings != null) {
                        errorCount = theErrorStrings.length;
                        for (j = 0; j < errorCount; ++j) {
                            theMessage = new VWString("vw.api.VWSimpleInstructionExecuteOpParamSyntaxError", "Execute instruction for operation, {0}, parameter[{1}] syntax error: {2}", "\"" + this.params[0] + "." + this.params[1] + "\"", String.valueOf(i - 1) + " - (" + sParamName + ")", theErrorStrings[j]);
                            theError = new VWValidationError(7, 1, myStep.getName(), sParamName, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError);
                        }
                        continue;
                    }
                    if (theParamDefs[i - 2].getIsArray() != compRes.getResultIsArray()) {
                        theMessage = new VWString("vw.api.VWSimpleInstructionExecuteOpParamArrayTypeMismatch", "Execute instruction parameter[{0}], whose value is ({1}), Array v. non-array mismatch", String.valueOf(i - 1) + " (" + sParamName + ")", this.params[i]);
                        theError = new VWValidationError(7, 1, myStep.getName(), sParamName, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                        continue;
                    }
                    if (VWFieldType.isCompatibleType(theParamDefs[i - 2].getDataType(), compRes.getResultType())) continue;
                    theMessage = new VWString("vw.api.VWSimpleInstructionExecuteOpParamIncompatibleExpressionType", "Execute operation parameter[{0}], value type found {1}, expected {2}", String.valueOf(i - 1) + " - (" + sParamName + ")", VWFieldType.typeToString(compRes.getResultType()), VWFieldType.typeToString(theParamDefs[i - 2].getDataType()));
                    theError = new VWValidationError(7, 1, myStep.getName(), sParamName, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
                break;
            }
            case 6: {
                myColl = myStep.getMap().getWorkflow().getWorkflowCollection();
                usingLocalWC = false;
                if (this.params != null && this.params[0] != null && (this.params[0].equals("WorkObject") || this.params[0].equals("WorkObjectEx"))) {
                    theMessage = new VWString("vw.api.VWSimpleInstructionCreateIllegalWC", "Create instruction not allowed to create a work object whose WorkClass is {0}.", this.params[0]);
                    theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
                if ((theSession = validationContext.getVWSession()) == null) break;
                createWC = null;
                createBaseWC = null;
                if (this.params == null || this.params[0] == null) {
                    theMessage = new VWString("vw.api.VWSimpleInstructionCreateNoParams", "Create instruction has no parameters defined.");
                    theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                    break;
                }
                if (myColl != null && myColl.isExistingWorkflowName(this.params[0], true) && myColl.getWorkflow(this.params[0], true).getTransferFlag()) {
                    createWC = myColl.getWorkflow(this.params[0], true).getWorkflowSignature(validationContext);
                    usingLocalWC = true;
                    createBaseWC = myColl.getWorkflow(this.params[0], true).getBaseWorkflowSignature(validationContext);
                } else {
                    try {
                        createWC = theSession.fetchWorkflowSignature(this.params[0]);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (createWC == null) {
                    theMessage = new VWString("vw.api.VWSimpleInstructionCreateNotExistWC", "Create instruction references work class, {0}, but no work class of that name was found with the transfer flag set in the workflow collection or on the server.", this.params[0]);
                    theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
                if (!usingLocalWC) {
                    theMessage = new VWString("vw.api.VWSimpleInstructionCreateWCnotInCollection", "Create instruction references work class, {0}, but no work class of that name was found with the transfer flag set in the workflow collection. Using the definition previously  transferred to the server.", this.params[0]);
                    theError = new VWValidationError(7, 2, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
                if (!usingLocalWC && myColl != null && myColl.isExistingWorkflowName(this.params[0], true) && !myColl.getWorkflow(this.params[0], true).getTransferFlag()) {
                    theMessage = new VWString("vw.api.VWSimpleInstructionCreateWCnotInCollection", "Create instruction is creating a work object whose WorkClass, {0}, exists in the workflow collection but it does not have the transfer flag set, using the definition previously transferred to the server.", this.params[0]);
                    theError = new VWValidationError(7, 2, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
                if (this.params.length <= 1) break;
                for (i = 1; i < this.params.length; i += 2) {
                    lCompRes = new VWCompiledRefExpr();
                    theErrorStrings = VWExpr.compileVWExpr(":=" + this.params[i], createWC, createBaseWC, myWflSignature, myBaseWflSignature, true, lCompRes);
                    if (theErrorStrings != null) {
                        errorCount = theErrorStrings.length;
                        for (k = 0; k < errorCount; ++k) {
                            theMessage = new VWString("vw.api.VWSimpleInstructionCreateAsgnBadLValue", "Create Instruction, Assignment, the Left side of the assignment, {0}, is not a valid LValue. Syntax Error: {1}", this.params[i], theErrorStrings[k]);
                            theError = new VWValidationError(7, 1, myStep.getName(), this.params[i], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError);
                        }
                        continue;
                    }
                    expectedRValueType = lCompRes.getResultType();
                    expectedRValueIsArray = lCompRes.getResultIsArray();
                    rCompRes = new VWCompiledExpr();
                    theErrorStrings = VWExpr.compileVWExpr(this.params[i + 1], myWflSignature, myBaseWflSignature, createWC, createBaseWC, true, rCompRes);
                    if (theErrorStrings != null) {
                        errorCount = theErrorStrings.length;
                        for (j = 0; j < errorCount; ++j) {
                            theMessage = new VWString("vw.api.VWSimpleInstructionCreateAsgnRValSyntaxError", "Create Instruction, Assignment[{0}], RValue (expected type is {1}). Syntax error: {2}", String.valueOf((i + 1) / 2), VWFieldType.typeToString(expectedRValueType) + (expectedRValueIsArray != false ? " array " : ""), theErrorStrings[j]);
                            theError = new VWValidationError(7, 1, myStep.getName(), this.params[i + 1], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError);
                        }
                        continue;
                    }
                    if (VWFieldType.isCompatibleType(lCompRes.getResultType(), rCompRes.getResultType()) && lCompRes.getResultIsArray() == rCompRes.getResultIsArray()) continue;
                    theMessage = new VWString("vw.api.VWSimpleInstructionCreateAsgnTypeMismatch", "Create Instruction, Assignment[{0}], Incompatible type, expected {1}, found {2}.", String.valueOf((i + 1) / 2), VWFieldType.typeToString(lCompRes.getResultType()) + (lCompRes.getResultIsArray() != false ? "[ ]" : ""), VWFieldType.typeToString(rCompRes.getResultType()) + (rCompRes.getResultIsArray() != false ? "[ ]" : ""));
                    theError = new VWValidationError(7, 1, myStep.getName(), this.params[i + 1], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
                break;
            }
            case 0: {
                if (this.params == null || paramCount % 2 != 0) break;
                for (i = 0; i < this.params.length; i += 2) {
                    lCompRes = new VWCompiledRefExpr();
                    theErrorStrings = VWExpr.compileVWExpr(":=" + this.params[i], myWflSignature, myBaseWflSignature, null, null, true, lCompRes);
                    if (theErrorStrings != null) {
                        errorCount = theErrorStrings.length;
                        for (k = 0; k < errorCount; ++k) {
                            theMessage = new VWString("vw.api.VWSimpleInstructionAsgnBadLValue", "Assignment, the Left side of the assignment, {0}, is not a valid LValue, Syntax Error {1}", this.params[i], theErrorStrings[k]);
                            theError = new VWValidationError(7, 1, myStep.getName(), this.params[i], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError);
                        }
                        continue;
                    }
                    expectedRValueType = lCompRes.getResultType();
                    expectedRValueIsArray = lCompRes.getResultIsArray();
                    rCompRes = new VWCompiledExpr();
                    theErrorStrings = VWExpr.compileVWExpr(this.params[i + 1], myWflSignature, myBaseWflSignature, null, null, true, rCompRes);
                    if (theErrorStrings != null) {
                        errorCount = theErrorStrings.length;
                        for (j = 0; j < errorCount; ++j) {
                            theMessage = new VWString("vw.api.VWSimpleInstructionAsgnRValSyntaxError", "Assignment[{0}], RValue (expected type is {1}) syntax error: {2}", String.valueOf(i / 2), VWFieldType.typeToString(expectedRValueType) + (expectedRValueIsArray != false ? " array " : ""), theErrorStrings[j]);
                            theError = new VWValidationError(7, 1, myStep.getName(), this.params[i + 1], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError);
                        }
                        continue;
                    }
                    if (VWFieldType.isCompatibleType(lCompRes.getResultType(), rCompRes.getResultType()) && lCompRes.getResultIsArray() == rCompRes.getResultIsArray()) continue;
                    theMessage = new VWString("vw.api.VWSimpleInstructionAsgnTypeMismatch", "Assignment[{0}], Incompatible type, expected {1}, found {2}.", String.valueOf(i / 2), VWFieldType.typeToString(lCompRes.getResultType()) + (lCompRes.getResultIsArray() != false ? "[ ]" : ""), VWFieldType.typeToString(rCompRes.getResultType()) + (rCompRes.getResultIsArray() != false ? "[ ]" : ""));
                    theError = new VWValidationError(7, 1, myStep.getName(), this.params[i + 1], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
                break;
            }
            case 37: {
                if (this.params != null && this.params[0] != null) {
                    compRes = new VWCompiledExpr();
                    theErrorStrings = VWExpr.compileVWExpr(this.params[0], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                    if (theErrorStrings != null) {
                        errorCount = theErrorStrings.length;
                        for (i = 0; i < errorCount; ++i) {
                            theMessage = new VWString("vw.api.VWSimpleInstructionSyntaxErrorDatabaseName", "Syntax error in database name of DB execute instruction (string expression) : {0}", theErrorStrings[i]);
                            theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError);
                        }
                    } else if (compRes.getResultIsArray() || compRes.getResultType() != 2) {
                        theMessage = new VWString("vw.api.VWSimpleInstructionDBNameNotString", "Database name must be a string literal, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() != false ? "[ ]" : ""));
                        theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    } else if (this.params[0].trim().charAt(0) != '\"' && this.params[0].trim().charAt(0) != '\'') {
                        theMessage = new VWString("vw.api.VWSimpleInstructionDBNameNotStringLiteral", "Database name must be a quoted string literal.");
                        theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    }
                }
                if (this.params != null && this.params[1] != null) {
                    compRes = new VWCompiledExpr();
                    theErrorStrings = VWExpr.compileVWExpr(this.params[1], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                    if (theErrorStrings != null) {
                        errorCount = theErrorStrings.length;
                        for (i = 0; i < errorCount; ++i) {
                            theMessage = new VWString("vw.api.VWSimpleInstructionSyntaxErrorStoredProcedureName", "Syntax error in stored procedure name of Database execute instruction (string expression) : {0}", theErrorStrings[i]);
                            theError = new VWValidationError(7, 1, myStep.getName(), this.params[1], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError);
                        }
                    } else if (compRes.getResultIsArray() || compRes.getResultType() != 2) {
                        theMessage = new VWString("vw.api.VWSimpleInstructionSPNameNotString", "Stored procedure name in database execute instruction must be a string literal, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() != false ? "[ ]" : ""));
                        theError = new VWValidationError(7, 1, myStep.getName(), this.params[1], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    } else if (this.params[1].trim().charAt(0) != '\"' && this.params[1].trim().charAt(0) != '\'') {
                        theMessage = new VWString("vw.api.VWSimpleInstructionSPNameNotStringLiteral", "Stored procedure name in database execute instruction must be a quoted string literal.");
                        theError = new VWValidationError(7, 1, myStep.getName(), this.params[1], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    }
                }
                for (i = 2; i < paramCount; ++i) {
                    lCompRes = new VWCompiledRefExpr();
                    theErrorStrings = VWExpr.compileVWExpr(":=" + this.params[i], myWflSignature, myBaseWflSignature, null, null, true, lCompRes);
                    if (theErrorStrings != null) {
                        errorCount = theErrorStrings.length;
                        for (k = 0; k < errorCount; ++k) {
                            theMessage = new VWString("vw.api.VWSimpleInstructionDBExecuteBadLValue", "DB Execute, the stored procedure parameter, {0}, is not a valid LValue, Syntax Error {1}", this.params[i], theErrorStrings[k]);
                            theError = new VWValidationError(7, 1, myStep.getName(), this.params[i], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError);
                        }
                        continue;
                    }
                    if (!lCompRes.getResultIsArray()) continue;
                    theMessage = new VWString("vw.api.VWSimpleInstructionDBExecuteNoArrayParams", "DB Execute, bad parameter, the stored procedure parameter, {0}, is an array, parameters cannot be arrays.", this.params[i]);
                    theError = new VWValidationError(7, 1, myStep.getName(), this.params[i], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError);
                }
                break;
            }
            case 38: {
                if (this.params != null && this.params[0] != null) {
                    compRes = new VWCompiledExpr();
                    theErrorStrings = VWExpr.compileVWExpr(this.params[0], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                    if (theErrorStrings != null) {
                        errorCount = theErrorStrings.length;
                        for (i = 0; i < errorCount; ++i) {
                            theMessage = new VWString("vw.api.VWSimpleInstructionSyntaxErrorInEventType", "Syntax error in Event Type of log instruction (string expression) : {0}", theErrorStrings[i]);
                            theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                            validationContext.addValidationError(theError);
                        }
                    } else if (compRes.getResultIsArray() || compRes.getResultType() != 1) {
                        theMessage = new VWString("vw.api.VWSimpleInstructionEventTypeNotInteger", "Event Type parameter must be an integer expression, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() != false ? "[ ]" : ""));
                        theError = new VWValidationError(7, 1, myStep.getName(), this.params[0], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    }
                }
                if (this.params == null || this.params[1] == null) break;
                compRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(this.params[1], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                if (theErrorStrings != null) {
                    errorCount = theErrorStrings.length;
                    for (i = 0; i < errorCount; ++i) {
                        theMessage = new VWString("vw.api.VWSimpleInstructionSyntaxErrorInEventText", "Syntax error in Event Text of log instruction (string expression) : {0}", theErrorStrings[i]);
                        theError = new VWValidationError(7, 1, myStep.getName(), this.params[1], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError);
                    }
                    break;
                }
                if (!compRes.getResultIsArray() && compRes.getResultType() == 2) break;
                theMessage = new VWString("vw.api.VWSimpleInstructionEventTextNotString", "Log message parameter must be a string expression, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() != false ? "[ ]" : ""));
                theError = new VWValidationError(7, 1, myStep.getName(), this.params[1], theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
            }
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWCompoundStepDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t\t<Instruction\n");
        theBuffer.append(ATTRIB_INDENT + "Id=\"" + Integer.toString(this.getInstructionId()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Action=\"" + VWActionType.typeToString(this.getAction()) + "\"");
        theBuffer.append(">\n");
        if (this.params != null) {
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i] == null) continue;
                theBuffer.append(ATTRIB_INDENT + "<Expression Val=\"" + VWXMLHandler.toXMLString(this.params[i]) + "\" />\n");
            }
        }
        theBuffer.append("\t\t\t</Instruction>\n");
    }

    public String toString() {
        String retVal = "";
        try {
            retVal = VWActionType.typeToString(this.action) + "(";
            for (int i = 0; i < this.params.length; ++i) {
                retVal = " <" + this.params[i] + "> ";
            }
            retVal = retVal + ")";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }
}

